/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.range;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.semver4j.Semver;

public class Range {
    private final Semver rangeVersion;
    private final RangeOperator rangeOperator;

    public Range(Semver rangeVersion, RangeOperator rangeOperator) {
        this.rangeVersion = rangeVersion;
        this.rangeOperator = rangeOperator;
    }

    public Range(String rangeVersion, RangeOperator rangeOperator) {
        this(new Semver(rangeVersion), rangeOperator);
    }

    public Semver getRangeVersion() {
        return this.rangeVersion;
    }

    public boolean isSatisfiedByAny() {
        return this.rangeVersion.isEqualTo(Semver.ZERO) && this.rangeOperator == RangeOperator.GTE;
    }

    public boolean isSatisfiedBy(String version) {
        return this.isSatisfiedBy(new Semver(version));
    }

    public boolean isSatisfiedBy(Semver version) {
        return switch (this.rangeOperator) {
            default -> throw new IncompatibleClassChangeError();
            case RangeOperator.EQ -> version.isEquivalentTo(this.rangeVersion);
            case RangeOperator.LT -> version.isLowerThan(this.rangeVersion);
            case RangeOperator.LTE -> version.isLowerThanOrEqualTo(this.rangeVersion);
            case RangeOperator.GT -> version.isGreaterThan(this.rangeVersion);
            case RangeOperator.GTE -> version.isGreaterThanOrEqualTo(this.rangeVersion);
        };
    }

    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Range range = (Range)o2;
        return Objects.equals(this.rangeVersion, range.rangeVersion) && this.rangeOperator == range.rangeOperator;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rangeVersion, this.rangeOperator});
    }

    public String toString() {
        return this.rangeOperator.asString() + String.valueOf(this.rangeVersion);
    }

    public static enum RangeOperator {
        EQ("="),
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">=");

        private final String string;

        private RangeOperator(String string2) {
            this.string = string2;
        }

        public String asString() {
            return this.string;
        }

        public static RangeOperator value(String string) {
            if (string.isEmpty()) {
                return EQ;
            }
            return Arrays.stream(RangeOperator.values()).filter(rangeOperator -> rangeOperator.asString().equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(Locale.ROOT, "Range operator for '%s' not found", string)));
        }
    }
}

