/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.semver4j.internal.Tokenizers;
import org.semver4j.internal.Utils;
import org.semver4j.processor.Processor;
import org.semver4j.range.Range;

public class TildeProcessor
implements Processor {
    private static final Pattern PATTERN = Pattern.compile(Tokenizers.TILDE);

    @Override
    public @Nullable String process(String range, boolean includePreRelease) {
        Matcher matcher = PATTERN.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        int major = Utils.parseIntWithXSupport(matcher.group(1));
        int minor = Utils.parseIntWithXSupport(matcher.group(2));
        int patch = Utils.parseIntWithXSupport(matcher.group(3));
        String explicitPreRelease = matcher.group(4);
        String preRelease = includePreRelease ? "-0" : "";
        return this.createVersionRange(major, minor, patch, explicitPreRelease, preRelease);
    }

    private String createVersionRange(int major, int minor, int patch, String explicitPreRelease, String preRelease) {
        String to;
        String from;
        if (Utils.isX(minor)) {
            from = this.formatVersion(Range.RangeOperator.GTE, major, 0, 0, preRelease);
            to = this.formatVersion(Range.RangeOperator.LT, major + 1, 0, 0, preRelease);
        } else if (Utils.isX(patch)) {
            from = this.formatVersion(Range.RangeOperator.GTE, major, minor, 0, preRelease);
            to = this.formatVersion(Range.RangeOperator.LT, major, minor + 1, 0, preRelease);
        } else if (Utils.isNotBlank(explicitPreRelease)) {
            from = String.format(Locale.ROOT, "%s%d.%d.%d-%s", Range.RangeOperator.GTE.asString(), major, minor, patch, explicitPreRelease);
            to = this.formatVersion(Range.RangeOperator.LT, major, minor + 1, 0, preRelease);
        } else {
            from = this.formatVersion(Range.RangeOperator.GTE, major, minor, patch, "");
            to = this.formatVersion(Range.RangeOperator.LT, major, minor + 1, 0, preRelease);
        }
        return String.format(Locale.ROOT, "%s %s", from, to);
    }

    private String formatVersion(Range.RangeOperator operator, int major, int minor, int patch, String preRelease) {
        return String.format(Locale.ROOT, "%s%d.%d.%d%s", operator.asString(), major, minor, patch, preRelease);
    }
}

