/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.semver4j.processor.Processor;
import org.semver4j.processor.Processors;

public class CompositeProcessor
implements Processor {
    private final List<Processor> processors;

    private CompositeProcessor(List<Processor> processors) {
        this.processors = Objects.requireNonNull(processors, "processors cannot be null");
    }

    public static Processor all() {
        return new CompositeProcessor(Processors.ALL_PROCESSORS);
    }

    public static Processor of(Processor ... processors) {
        return new CompositeProcessor(List.of(processors));
    }

    @Override
    public @Nullable String process(String range, boolean includePreRelease) {
        return this.processors.stream().map(processor -> processor.process(range, includePreRelease)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

