/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.semver4j.Semver;

public class Comparator {
    private static final String ALL_DIGITS = "^\\d+$";
    private static final String CONTAINS_DIGITS = ".*\\d.*";
    private static final String TRAILING_DIGITS_EXTRACT = "(?<=\\D)(?=\\d)";
    private static final String LEADING_DIGITS_EXTRACT = "(?<=\\d)(?=\\D)";
    private static final String UNDEFINED_MARKER = "undef";

    private Comparator() {
    }

    public static int compareTo(Semver version, Semver other) {
        int result = Comparator.mainCompare(version, other);
        if (result == 0) {
            return Comparator.preReleaseCompare(version, other);
        }
        return result;
    }

    private static int mainCompare(Semver version, Semver other) {
        int majorCompare = Long.compare(version.getMajor(), other.getMajor());
        if (majorCompare == 0) {
            int minorCompare = Long.compare(version.getMinor(), other.getMinor());
            if (minorCompare == 0) {
                return Long.compare(version.getPatch(), other.getPatch());
            }
            return minorCompare;
        }
        return majorCompare;
    }

    private static int preReleaseCompare(Semver version, Semver other) {
        if (!version.getPreRelease().isEmpty() && other.getPreRelease().isEmpty()) {
            return -1;
        }
        if (version.getPreRelease().isEmpty() && !other.getPreRelease().isEmpty()) {
            return 1;
        }
        if (version.getPreRelease().isEmpty() && other.getPreRelease().isEmpty()) {
            return 0;
        }
        int maxElements = Math.max(version.getPreRelease().size(), other.getPreRelease().size());
        int i2 = 0;
        do {
            String a2 = Comparator.getString(i2, version.getPreRelease());
            String b2 = Comparator.getString(i2, other.getPreRelease());
            ++i2;
            if (a2.equals(UNDEFINED_MARKER) && b2.equals(UNDEFINED_MARKER)) {
                return 0;
            }
            if (b2.equals(UNDEFINED_MARKER)) {
                return 1;
            }
            if (a2.equals(UNDEFINED_MARKER)) {
                return -1;
            }
            if (a2.equals(b2)) continue;
            return Comparator.compareIdentifiers(a2, b2);
        } while (maxElements > i2);
        return 0;
    }

    private static int compareIdentifiers(String a2, String b2) {
        Integer alphaNumericComparison;
        if (a2.matches(ALL_DIGITS) && b2.matches(ALL_DIGITS)) {
            long aAsLong = Long.parseLong(a2);
            long bAsLong = Long.parseLong(b2);
            return Long.compare(aAsLong, bAsLong);
        }
        if (a2.matches(CONTAINS_DIGITS) && b2.matches(CONTAINS_DIGITS) && (alphaNumericComparison = Comparator.checkAlphanumericPrerelease(a2, b2)) != null) {
            return alphaNumericComparison;
        }
        int i2 = a2.compareTo(b2);
        if (i2 > 0) {
            return 1;
        }
        if (i2 < 0) {
            return -1;
        }
        return 0;
    }

    private static @Nullable Integer checkAlphanumericPrerelease(String a2, String b2) {
        String[] tokenArrB;
        String[] tokenArrA = a2.split(TRAILING_DIGITS_EXTRACT);
        if (tokenArrA.length != (tokenArrB = b2.split(TRAILING_DIGITS_EXTRACT)).length) {
            return tokenArrA.length - tokenArrB.length;
        }
        if (tokenArrA[0].equals(tokenArrB[0])) {
            long digitB;
            String[] leadingDigitsArrA = tokenArrA[1].split(LEADING_DIGITS_EXTRACT);
            String[] leadingDigitsArrB = tokenArrB[1].split(LEADING_DIGITS_EXTRACT);
            long digitA = Long.parseLong(leadingDigitsArrA[0]);
            int digitComparison = Long.compare(digitA, digitB = Long.parseLong(leadingDigitsArrB[0]));
            if (digitComparison != 0) {
                return digitComparison;
            }
            if (leadingDigitsArrA.length != leadingDigitsArrB.length) {
                return leadingDigitsArrA.length - leadingDigitsArrB.length;
            }
            return Comparator.compareIdentifiers(a2.substring(a2.indexOf(leadingDigitsArrA[0]) + 1), b2.substring(b2.indexOf(leadingDigitsArrB[0]) + 1));
        }
        return null;
    }

    private static String getString(int i2, List<String> list) {
        return list.size() > i2 ? list.get(i2) : UNDEFINED_MARKER;
    }
}

