/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.semver4j.internal.Coerce;
import org.semver4j.internal.Comparator;
import org.semver4j.internal.Differ;
import org.semver4j.internal.Modifier;
import org.semver4j.internal.VersionParser;
import org.semver4j.range.RangeExpression;
import org.semver4j.range.RangeList;
import org.semver4j.range.RangeListFactory;

public class Semver
implements Comparable<Semver> {
    public static final Semver ZERO = new Semver("0.0.0");
    private final int major;
    private final int minor;
    private final int patch;
    private final List<String> preRelease;
    private final List<String> build;
    private final String version;

    public Semver(String version) {
        Objects.requireNonNull(version, "version must not be null");
        VersionParser.Version parsedVersion = VersionParser.parse(version.trim());
        this.major = parsedVersion.major();
        this.minor = parsedVersion.minor();
        this.patch = parsedVersion.patch();
        this.preRelease = parsedVersion.preRelease();
        this.build = parsedVersion.build();
        this.version = new Builder().withMajor(this.major).withMinor(this.minor).withPatch(this.patch).withPreReleases(this.preRelease).withBuilds(this.build).toVersion();
    }

    public static @Nullable Semver parse(@Nullable String version) {
        if (version == null) {
            return null;
        }
        try {
            return new Semver(version);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static @Nullable Semver coerce(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Semver semver = Semver.parse(version);
        if (semver != null) {
            return semver;
        }
        String coercedVersion = Coerce.coerce(version);
        return Semver.parse(coercedVersion);
    }

    public static boolean isValid(@Nullable String version) {
        return Semver.parse(version) != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder of(int major, int minor, int patch) {
        return Semver.builder().withMajor(major).withMinor(minor).withPatch(patch);
    }

    public static Semver create(int major, int minor, int patch) {
        return Semver.of(major, minor, patch).build();
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public List<String> getPreRelease() {
        return this.preRelease;
    }

    public List<String> getBuild() {
        return this.build;
    }

    public boolean isStable() {
        return this.major > 0 && this.preRelease.isEmpty();
    }

    public Semver nextMajor() {
        return Modifier.nextMajor(this);
    }

    public Semver withIncMajor() {
        return this.withIncMajor(1);
    }

    public Semver withIncMajor(int number) {
        return Modifier.withIncMajor(this, number);
    }

    public Semver nextMinor() {
        return Modifier.nextMinor(this);
    }

    public Semver withIncMinor() {
        return this.withIncMinor(1);
    }

    public Semver withIncMinor(int number) {
        return Modifier.withIncMinor(this, number);
    }

    public Semver nextPatch() {
        return Modifier.nextPatch(this);
    }

    public Semver withIncPatch() {
        return this.withIncPatch(1);
    }

    public Semver withIncPatch(int number) {
        return Modifier.withIncPatch(this, number);
    }

    public Semver withPreRelease(String preRelease) {
        return Modifier.withPreRelease(this, preRelease);
    }

    public Semver withBuild(String build) {
        return Modifier.withBuild(this, build);
    }

    public Semver withClearedPreRelease() {
        return Modifier.withClearedPreRelease(this);
    }

    public Semver withClearedBuild() {
        return Modifier.withClearedBuild(this);
    }

    public Semver withClearedPreReleaseAndBuild() {
        return Modifier.withClearedPreReleaseAndBuild(this);
    }

    @Override
    public int compareTo(Semver other) {
        return Comparator.compareTo(this, other);
    }

    public boolean isApiCompatible(String version) {
        return this.isApiCompatible(new Semver(version));
    }

    public boolean isApiCompatible(Semver version) {
        return this.diff(version).ordinal() < VersionDiff.MAJOR.ordinal();
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Semver(version));
    }

    public boolean isGreaterThan(Semver version) {
        return this.compareTo(version) > 0;
    }

    public boolean isGreaterThanOrEqualTo(String version) {
        return this.isGreaterThanOrEqualTo(new Semver(version));
    }

    public boolean isGreaterThanOrEqualTo(Semver version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLowerThan(String version) {
        return this.isLowerThan(new Semver(version));
    }

    public boolean isLowerThan(Semver version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLowerThanOrEqualTo(String version) {
        return this.isLowerThanOrEqualTo(new Semver(version));
    }

    public boolean isLowerThanOrEqualTo(Semver version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isEqualTo(String version) {
        return this.isEqualTo(new Semver(version));
    }

    public boolean isEqualTo(Semver version) {
        return this.equals(version);
    }

    public boolean isEquivalentTo(String version) {
        return this.isEquivalentTo(new Semver(version));
    }

    public boolean isEquivalentTo(Semver version) {
        return this.compareTo(version) == 0;
    }

    public VersionDiff diff(String version) {
        return this.diff(new Semver(version));
    }

    public VersionDiff diff(Semver version) {
        return Differ.diff(this, version);
    }

    public boolean satisfies(String range) {
        return this.satisfies(range, false);
    }

    public boolean satisfies(String range, boolean includePreRelease) {
        RangeList rangeList = RangeListFactory.create(range, includePreRelease);
        return this.satisfies(rangeList);
    }

    public boolean satisfies(RangeExpression rangeExpression) {
        RangeList rangeList = RangeListFactory.create(rangeExpression);
        return this.satisfies(rangeList);
    }

    public boolean satisfies(RangeList rangeList) {
        return rangeList.isSatisfiedBy(this);
    }

    public String format(Function<Semver, String> formatter) {
        return formatter.apply(this);
    }

    public boolean equals(@Nullable Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Semver)) {
            return false;
        }
        return this.version.equals(((Semver)o2).version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return this.getVersion();
    }

    public static class Builder {
        private int major;
        private int minor;
        private int patch;
        private List<String> preRelease = Collections.emptyList();
        private List<String> build = Collections.emptyList();

        public Builder withMajor(int major) {
            this.major = major;
            return this;
        }

        public Builder withMinor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder withPatch(int patch) {
            this.patch = patch;
            return this;
        }

        public Builder withPreRelease(String preRelease) {
            Objects.requireNonNull(preRelease, "preRelease cannot be null");
            return this.withPreReleases(List.of(preRelease));
        }

        public Builder withPreReleases(Collection<String> preReleases) {
            Objects.requireNonNull(preReleases, "preReleases cannot be null");
            this.preRelease = List.copyOf(preReleases);
            return this;
        }

        public Builder withPreReleases(String ... preReleases) {
            Objects.requireNonNull(preReleases, "preReleases cannot be null");
            this.preRelease = List.of(preReleases);
            return this;
        }

        public Builder withBuild(String build) {
            Objects.requireNonNull(build, "build cannot be null");
            return this.withBuilds(List.of(build));
        }

        public Builder withBuilds(Collection<String> builds) {
            Objects.requireNonNull(builds, "builds cannot be null");
            this.build = List.copyOf(builds);
            return this;
        }

        public Builder withBuilds(String ... builds) {
            Objects.requireNonNull(builds, "builds cannot be null");
            this.build = List.of(builds);
            return this;
        }

        public Semver build() {
            String version = this.toVersion();
            return new Semver(version);
        }

        private String toVersion() {
            Object resultVersion = String.format(Locale.ROOT, "%d.%d.%d", this.major, this.minor, this.patch);
            if (!this.preRelease.isEmpty()) {
                resultVersion = (String)resultVersion + "-" + String.join((CharSequence)".", this.preRelease);
            }
            if (!this.build.isEmpty()) {
                resultVersion = (String)resultVersion + "+" + String.join((CharSequence)".", this.build);
            }
            return resultVersion;
        }
    }

    public static enum VersionDiff {
        NONE,
        BUILD,
        PRE_RELEASE,
        PATCH,
        MINOR,
        MAJOR;

    }
}

