/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.internal.ByteBuffer;

public class StringUtils {
    public static String[] split(String text, String separator) {
        int max = -1;
        StringTokenizer tok = separator == null ? new StringTokenizer(text) : new StringTokenizer(text, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i2 = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i2 == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = text.indexOf(endToken, lastTokenEnd);
                list[i2] = text.substring(lastTokenBegin);
                break;
            }
            list[i2] = tok.nextToken();
            lastTokenBegin = text.indexOf(list[i2], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i2].length();
            ++i2;
        }
        return list;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static void unescapeJava(StringWriter out, String str) {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new NestedRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.write(92);
                        break;
                    }
                    case '\'': {
                        out.write(39);
                        break;
                    }
                    case '\"': {
                        out.write(34);
                        break;
                    }
                    case 'r': {
                        out.write(13);
                        break;
                    }
                    case 'f': {
                        out.write(12);
                        break;
                    }
                    case 't': {
                        out.write(9);
                        break;
                    }
                    case 'n': {
                        out.write(10);
                        break;
                    }
                    case 'b': {
                        out.write(8);
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.write(ch);
        }
        if (hadSlash) {
            out.write(92);
        }
    }

    public static int unescapeJava(byte[] out, String str) {
        int outPos = 0;
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return 0;
        }
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out[outPos++] = (byte)value;
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new NestedRuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out[outPos++] = 92;
                        break;
                    }
                    case '\'': {
                        out[outPos++] = 39;
                        break;
                    }
                    case '\"': {
                        out[outPos++] = 34;
                        break;
                    }
                    case 'r': {
                        out[outPos++] = 13;
                        break;
                    }
                    case 'f': {
                        out[outPos++] = 12;
                        break;
                    }
                    case 't': {
                        out[outPos++] = 9;
                        break;
                    }
                    case 'n': {
                        out[outPos++] = 10;
                        break;
                    }
                    case 'b': {
                        out[outPos++] = 8;
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out[outPos++] = (byte)ch;
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out[outPos++] = (byte)ch;
        }
        if (hadSlash) {
            out[outPos++] = 92;
        }
        return outPos;
    }

    public static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (ch > '\u0fff') {
                out.write("\\u" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f' || ch == ',') {
                out.write("\\u00" + StringUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + StringUtils.hex(ch));
                            break;
                        }
                        out.write("\\u000" + StringUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    out.write(92);
                    out.write(47);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static void escapeJavaStyleString(ByteBuffer out, byte[] str, int off, int len) {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        int inputLength = str.length;
        if (str == null || inputLength == 0) {
            return;
        }
        int outputPos = 0;
        int end = off + len;
        block13: for (int i2 = off; i2 < end; ++i2) {
            char ch = (char)str[i2];
            if (ch > '\u0fff') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u0" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f' || ch == ',') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u00" + StringUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            outputPos = StringUtils.writeOut(out, outputPos, "\\u00" + StringUtils.hex(ch));
                            break;
                        }
                        outputPos = StringUtils.writeOut(out, outputPos, "\\u000" + StringUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append('\\');
                    out.append('\'');
                    continue block13;
                }
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block13;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block13;
                }
                case '/': {
                    out.append('\\');
                    out.append('/');
                    continue block13;
                }
                default: {
                    out.append(ch);
                }
            }
        }
    }

    public static void escapeJavaStyleString(PrintStream out, byte[] str, int off, int len) {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        int inputLength = str.length;
        if (str == null || inputLength == 0) {
            return;
        }
        int outputPos = 0;
        int end = off + len;
        block13: for (int i2 = off; i2 < end; ++i2) {
            char ch = (char)str[i2];
            if (ch > '\u0fff') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u0" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f' || ch == ',') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u00" + StringUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            outputPos = StringUtils.writeOut(out, outputPos, "\\u00" + StringUtils.hex(ch));
                            break;
                        }
                        outputPos = StringUtils.writeOut(out, outputPos, "\\u000" + StringUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append('\\');
                    out.append('\'');
                    continue block13;
                }
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block13;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block13;
                }
                case '/': {
                    out.append('\\');
                    out.append('/');
                    continue block13;
                }
                default: {
                    out.append(ch);
                }
            }
        }
    }

    public static int escapeJavaStyleString(byte[] out, int outoff, byte[] str, int off, int len) {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        int inputLength = str.length;
        if (str == null || inputLength == 0) {
            return 0;
        }
        int outputPos = outoff;
        int end = off + len;
        block13: for (int i2 = off; i2 < end; ++i2) {
            char ch = (char)str[i2];
            if (ch > '\u0fff') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u0" + StringUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f' || ch == ',') {
                outputPos = StringUtils.writeOut(out, outputPos, "\\u00" + StringUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out[outputPos++] = 92;
                        out[outputPos++] = 98;
                        break;
                    }
                    case '\n': {
                        out[outputPos++] = 92;
                        out[outputPos++] = 110;
                        break;
                    }
                    case '\t': {
                        out[outputPos++] = 92;
                        out[outputPos++] = 116;
                        break;
                    }
                    case '\f': {
                        out[outputPos++] = 92;
                        out[outputPos++] = 102;
                        break;
                    }
                    case '\r': {
                        out[outputPos++] = 92;
                        out[outputPos++] = 114;
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            outputPos = StringUtils.writeOut(out, outputPos, "\\u00" + StringUtils.hex(ch));
                            break;
                        }
                        outputPos = StringUtils.writeOut(out, outputPos, "\\u000" + StringUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out[outputPos++] = 92;
                    out[outputPos++] = 39;
                    continue block13;
                }
                case '\"': {
                    out[outputPos++] = 92;
                    out[outputPos++] = 34;
                    continue block13;
                }
                case '\\': {
                    out[outputPos++] = 92;
                    out[outputPos++] = 92;
                    continue block13;
                }
                case '/': {
                    out[outputPos++] = 92;
                    out[outputPos++] = 47;
                    continue block13;
                }
                default: {
                    out[outputPos++] = (byte)ch;
                }
            }
        }
        return outputPos - outoff;
    }

    private static int writeOut(ByteBuffer out, int outputPos, String msg) {
        byte[] bytes = msg.getBytes();
        for (int cnt = 0; cnt < bytes.length; ++cnt) {
            out.append(bytes[cnt]);
        }
        return outputPos;
    }

    private static int writeOut(PrintStream out, int outputPos, String msg) {
        byte[] bytes = msg.getBytes();
        for (int cnt = 0; cnt < bytes.length; ++cnt) {
            out.write(bytes[cnt]);
        }
        return outputPos;
    }

    private static int writeOut(byte[] out, int outputPos, String msg) {
        byte[] bytes = msg.getBytes();
        for (int cnt = 0; cnt < bytes.length; ++cnt) {
            out[outputPos++] = bytes[cnt];
        }
        return outputPos;
    }

    public static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static void escapeJavaStyleString(StringBuffer target, String str) {
        if (str == null) {
            return;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            StringUtils.escapeJavaStyleString(writer, str, true);
            target.append(writer.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void escapeJavaStyleString(PrintStream target, String str) {
        if (str == null) {
            return;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            StringUtils.escapeJavaStyleString(writer, str, true);
            target.append(writer.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

