/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class UrlUtils {
    private static final BitSet UNRESERVED = new BitSet(256);
    private static final int RADIX = 16;
    private static final int MASK = 15;
    private static final String ENCODING = "UTF-8";

    private UrlUtils() {
    }

    public static URL getURL(File file) throws MalformedURLException {
        URL url = file.toURL();
        try {
            byte[] bytes = url.toString().getBytes(ENCODING);
            StringBuffer buf = new StringBuffer(bytes.length);
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                byte b2 = bytes[i2];
                if (b2 > 0 && UNRESERVED.get(b2)) {
                    buf.append((char)b2);
                    continue;
                }
                buf.append('%');
                buf.append(Character.forDigit(b2 >>> 4 & 0xF, 16));
                buf.append(Character.forDigit(b2 & 0xF, 16));
            }
            return new URL(buf.toString());
        }
        catch (UnsupportedEncodingException e2) {
            throw new NestedRuntimeException(e2);
        }
    }

    static {
        try {
            byte[] bytes = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'():/".getBytes(ENCODING);
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                UNRESERVED.set(bytes[i2]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

