/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    protected final String testClass;
    protected final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t2) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t2;
    }

    public String writeTraceToString() {
        StringWriter w2 = new StringWriter();
        if (this.t != null) {
            this.t.printStackTrace(new PrintWriter(w2));
            w2.flush();
        }
        return w2.toString();
    }

    public String writeTrimmedTraceToString() {
        int i2;
        String text = this.writeTraceToString();
        String marker = "at " + this.testClass + "." + this.testMethod;
        String[] lines = StringUtils.split(text, "\n");
        int lastLine = lines.length - 1;
        int causedByLine = -1;
        for (int i3 = 1; i3 < lines.length; ++i3) {
            String line = lines[i3].trim();
            if (line.startsWith(marker)) {
                lastLine = i3;
                continue;
            }
            if (!line.startsWith("Caused by")) continue;
            causedByLine = i3;
            break;
        }
        StringBuffer trace = new StringBuffer();
        for (i2 = 0; i2 <= lastLine; ++i2) {
            trace.append(lines[i2]);
            trace.append("\n");
        }
        if (causedByLine != -1) {
            for (i2 = causedByLine; i2 < lines.length; ++i2) {
                trace.append(lines[i2]);
                trace.append("\n");
            }
        }
        return trace.toString();
    }

    public SafeThrowable getThrowable() {
        return new SafeThrowable(this.t);
    }
}

