/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.maven.surefire.booter.PropertiesWrapper;

public class SystemPropertyManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertiesWrapper loadProperties(InputStream inStream) throws IOException {
        Properties p2 = new Properties();
        try {
            p2.load(inStream);
        }
        finally {
            SystemPropertyManager.close(inStream);
        }
        return new PropertiesWrapper(p2);
    }

    private static PropertiesWrapper loadProperties(File file) throws IOException {
        return SystemPropertyManager.loadProperties(new FileInputStream(file));
    }

    public static void setSystemProperties(File file) throws IOException {
        PropertiesWrapper p2 = SystemPropertyManager.loadProperties(file);
        p2.setAsSystemProperties();
    }

    public static File writePropertiesFile(Properties properties, File tempDirectory, String name, boolean keepForkFiles) throws IOException {
        File file = File.createTempFile(name, "tmp", tempDirectory);
        if (!keepForkFiles) {
            file.deleteOnExit();
        }
        SystemPropertyManager.writePropertiesFile(file, name, properties);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePropertiesFile(File file, String name, Properties properties) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            properties.store(out, name);
        }
        finally {
            out.close();
        }
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

