/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class IsolatedClassLoader
extends URLClassLoader {
    private final ClassLoader parent = ClassLoader.getSystemClassLoader();
    private final Set urls = new HashSet();
    private final String roleName;
    private boolean childDelegation = true;
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public IsolatedClassLoader(ClassLoader parent, boolean childDelegation, String roleName) {
        super(EMPTY_URL_ARRAY, parent);
        this.childDelegation = childDelegation;
        this.roleName = roleName;
    }

    public void addURL(URL url) {
        if (!this.urls.contains(url)) {
            super.addURL(url);
            this.urls.add(url);
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        Class<?> c2;
        if (this.childDelegation) {
            ClassNotFoundException ex;
            block6: {
                c2 = this.findLoadedClass(name);
                ex = null;
                if (c2 == null) {
                    try {
                        c2 = this.findClass(name);
                    }
                    catch (ClassNotFoundException e2) {
                        ex = e2;
                        if (this.parent == null) break block6;
                        c2 = this.parent.loadClass(name);
                    }
                }
            }
            if (c2 == null) {
                throw ex;
            }
        } else {
            c2 = super.loadClass(name);
        }
        return c2;
    }

    public String toString() {
        return "IsolatedClassLoader{roleName='" + this.roleName + '\'' + '}';
    }
}

