/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.JdkReflector;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.util.UrlUtils;

public class Classpath {
    private static final JdkReflector jdkReflector = new JdkReflector();
    private final List elements;

    public static Classpath join(Classpath firstClasspath, Classpath secondClasspath) {
        Classpath joinedClasspath = new Classpath();
        joinedClasspath.addElementsOfClasspath(firstClasspath);
        joinedClasspath.addElementsOfClasspath(secondClasspath);
        return joinedClasspath;
    }

    public Classpath() {
        this.elements = new ArrayList();
    }

    public Classpath(Classpath other) {
        this.elements = new ArrayList(other.elements);
    }

    public Classpath(List elements) {
        this();
        this.addElements(elements);
    }

    public void addClassPathElementUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null is not a valid class path element url.");
        }
        if (!this.elements.contains(path)) {
            this.elements.add(path);
        }
    }

    private void addElements(List additionalElements) {
        Iterator it = additionalElements.iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            this.addClassPathElementUrl(element);
        }
    }

    private void addElementsOfClasspath(Classpath otherClasspath) {
        if (otherClasspath != null) {
            this.addElements(otherClasspath.elements);
        }
    }

    public List getClassPath() {
        return Collections.unmodifiableList(this.elements);
    }

    public List getAsUrlList() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator i2 = this.elements.iterator();
        while (i2.hasNext()) {
            String url = (String)i2.next();
            File f2 = new File(url);
            urls.add(UrlUtils.getURL(f2));
        }
        return urls;
    }

    public void writeToSystemProperty(String propertyName) {
        StringBuffer sb = new StringBuffer();
        Iterator i2 = this.elements.iterator();
        while (i2.hasNext()) {
            sb.append((String)i2.next()).append(File.pathSeparatorChar);
        }
        System.setProperty(propertyName, sb.toString());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Classpath classpath = (Classpath)o2;
        return !(this.elements == null ? classpath.elements != null : !((Object)this.elements).equals(classpath.elements));
    }

    public ClassLoader createClassLoader(ClassLoader parent, boolean childDelegation, boolean enableAssertions, String roleName) throws SurefireExecutionException {
        try {
            List urls = this.getAsUrlList();
            IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation, roleName);
            Iterator iter = urls.iterator();
            while (iter.hasNext()) {
                URL url = (URL)iter.next();
                classLoader.addURL(url);
            }
            if (parent != null) {
                jdkReflector.invokeAssertionStatusMethod(parent, enableAssertions);
            }
            jdkReflector.invokeAssertionStatusMethod(classLoader, enableAssertions);
            return classLoader;
        }
        catch (MalformedURLException e2) {
            throw new SurefireExecutionException("When creating classloader", e2);
        }
    }

    public int hashCode() {
        return this.elements != null ? ((Object)this.elements).hashCode() : 0;
    }
}

