/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.SelectorUtils;
import org.apache.maven.surefire.util.ScannerFilter;

public class SpecificTestClassFilter
implements ScannerFilter {
    private static final char FS = System.getProperty("file.separator").charAt(0);
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private Set names;

    public SpecificTestClassFilter(String[] classNames) {
        if (classNames != null && classNames.length > 0) {
            this.names = new HashSet();
            for (int i2 = 0; i2 < classNames.length; ++i2) {
                String name = classNames[i2];
                this.names.add(name);
            }
        }
    }

    public boolean accept(Class testClass) {
        boolean result = true;
        if (this.names != null && !this.names.isEmpty()) {
            String className = testClass.getName().replace('.', FS) + JAVA_CLASS_FILE_EXTENSION;
            boolean found = false;
            Iterator it = this.names.iterator();
            while (it.hasNext()) {
                String pattern = (String)it.next();
                if ('\\' == FS) {
                    pattern = pattern.replace('/', FS);
                }
                if (!SelectorUtils.matchPath(pattern, className, true)) continue;
                found = true;
                break;
            }
            if (!found) {
                result = false;
            }
        }
        return result;
    }
}

