/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.runorder;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.surefire.runorder.PrioritizedTest;

public class ThreadedExecutionScheduler {
    private final int numThreads;
    private final int[] runTime;
    private final List[] lists;

    public ThreadedExecutionScheduler(int numThreads) {
        this.numThreads = numThreads;
        this.runTime = new int[numThreads];
        this.lists = new List[numThreads];
        for (int i2 = 0; i2 < numThreads; ++i2) {
            this.lists[i2] = new ArrayList();
        }
    }

    public void addTest(PrioritizedTest prioritizedTest) {
        int leastBusySlot;
        int n2 = leastBusySlot = this.findLeastBusySlot();
        this.runTime[n2] = this.runTime[n2] + prioritizedTest.getTotalRuntime();
        this.lists[leastBusySlot].add(prioritizedTest.getClazz());
    }

    public List getResult() {
        ArrayList result = new ArrayList();
        int index = 0;
        boolean added = false;
        do {
            added = false;
            for (int i2 = 0; i2 < this.numThreads; ++i2) {
                if (this.lists[i2].size() <= index) continue;
                result.add(this.lists[i2].get(index));
                added = true;
            }
            ++index;
        } while (added);
        return result;
    }

    private int findLeastBusySlot() {
        int leastBusy = 0;
        int minRuntime = this.runTime[0];
        for (int i2 = 1; i2 < this.numThreads; ++i2) {
            if (this.runTime[i2] >= minRuntime) continue;
            leastBusy = i2;
            minRuntime = this.runTime[i2];
        }
        return leastBusy;
    }
}

